package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class DoorDestinationScreenObject extends ScreenObject {
	
	private DoorDestinationPaletteObject paletteObject;
	private IntRect clickRect;
	private boolean isSelected;
	
	public DoorDestinationScreenObject(int x, int y, DoorDestinationPaletteObject thePaletteObject) {
		
		paletteObject = thePaletteObject;
		
		int width = paletteObject.getWidth();
		int height = paletteObject.getHeight();
		
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
		
	}
	
	
	@Override
	public void draw(Graphics g) {

		DoorDestinationPaletteObject.getDoorDestImage(paletteObject.getDestionationRoom()).drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		if(paletteObject.shouldShowCaption()) {
			FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
			String dispStr = "from: " + paletteObject.getSourceRoom().getStaticBlockFactory().getRoomName();
			Rectangle2D strBounds = g.getFont().getStringBounds(dispStr, frc);
			g.setColor(Color.white);
			g.fillRect(clickRect.getMinX(), clickRect.getMaxY() + 2, 4 + (int) strBounds.getWidth(), 4 + (int) strBounds.getHeight());
			g.setColor(Color.black);
			g.drawString(dispStr, clickRect.getMinX() + 2,  clickRect.getMaxY() + 18);
			
		}
		
		if(paletteObject.getCaption() != null && paletteObject.getCaptionColor() != null) {
			g.setColor(paletteObject.getCaptionColor());
			
			Font origFont = g.getFont();
			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
			g.setFont(newFont);
			g.drawString(paletteObject.getCaption(), clickRect.getMinX() + 4, clickRect.getMaxY() - 10);
			g.setFont(origFont);
		}
		
		
		if(isSelected)
			drawSelectionOverObject(g);
		
		g.setColor(origCol);
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}
	
	@Override
	public int getLayer() {
		
		return 5;
	}
	
	public void informPaletteObjectOfDelete() {
		if(paletteObject == null)
			return;
		
		paletteObject.setDestinationPoint(null);
	}
	
	public void updateSourceRoomListItemColor() {
		if(paletteObject != null) {
			RoomEditorPanel rep = paletteObject.getSourceRoom();
			if(rep != null) {
				rep.getListItem().updateIconAndColor();
			}
		}
	}
	
	
	public String getNameOfSourceRoom() {
		
		if(paletteObject == null)
			return null;
		
		if(paletteObject.getSourceRoom() == null)
			return null;
		
		return paletteObject.getSourceRoom().getListItem().getName();
		
	}
}
